#define vertexSnapping // Turn on vertex snapping
#define resolution 0.2 // [0.2 0.25 0.5 1.0]

vec4 roundToNearestPixel(vec4 vertex, float viewWidth, float viewHeight)
{
	vertex.xyz /= vertex.w;
	
	vertex.xy = vertex.xy * 0.5 + 0.5;
	vertex.xy *= resolution;
	vertex.xy = vertex.xy * 2.0 - 1.0;
#ifdef vertexSnapping
	vertex.xy = vec2(floor(vertex.x * viewWidth + 0.5)/viewWidth, floor(vertex.y * viewHeight * resolution + 0.5)/(viewHeight * resolution));
#endif
	vertex.xyz *= vertex.w;

	return vertex;
}